<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('業務 儀表板') }}<span class="px-2">詢價清單</span>
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if ($products->isNotEmpty())
                @foreach ($products as $product)
                <div class="max-w-sm rounded-lg overflow-hidden shadow-lg bg-white p-6 md:flex items-center justify-center m-6">
                    <img class="h-48 object-cover rounded-lg mx-auto md:mx-0" src="{{ asset('images/products/'.$product->image) }}" alt="{{ $product->image }}">
                    <!--產品資訊-->
                    <div>
                        <h2 class="text-lg font-semibold text-gray-900 p-4">
                            {{ $product['brand_category'] }}/
                            {{ $product['series_category'] }}/
                            {{ $product['product_categories'] }}/
                            {{ $product['system_category'] }}
                        </h2>
                        <h3 class="text-lg font-semibold text-gray-900 p-4">產品ID：{{ $product['product_id'] }}</h3>
                        <h3 class="text-lg font-semibold text-gray-900 p-4">產品名稱：{{ $product['product_name'] }}</h3>
                        <div class="flex gap-4">
                            <div>規格：</div>
                            @if(!empty($product->diameter))
                            <div>直徑：{{ $product->diameter }}</div>
                            @endif
                            @if(!empty($product->length))
                            <div>長度：{{ $product->length }}</div>
                            @endif
                            @if(!empty($product->high))
                            <div>高度：{{ $product->high }}</div>
                            @endif
                            @if(!empty($product->cuff))
                            <div>cuff：{{ $product->cuff }}</div>
                            @endif
                            @if(!empty($product->angle))
                            <div>angle：{{ $product->angle }}°</div>
                            @endif
                            @if(!empty($product->type))
                            <div>type：{{ $product->type }}</div>
                            @endif
                            @if(!empty($product->post_h))
                            <div>PostH：{{ $product->post_h }}</div>
                            @endif
                        </div>
                    </div>
                    <!--價錢數量-->
                    <div>
                        <div class="m-6 flex items-center justify-center gap-3 hidden">
                            <label for="price-input-{{$product->id}}" class="text-gray-700 font-semibold">價錢</label>
                            <input id="price-input-{{ $product->id }}" 
                                    data-id="{{ $product->id }}" 
                                    min="0" 
                                    value="{{ $product->price }}" 
                                    type="number" 
                                    name="price-{{$product->id}}" 
                                    class="price-input px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="m-6 flex items-center justify-center gap-3">
                            <label for="quantity-input-{{$product->id}}" class="text-gray-700 font-semibold">數量</label>
                            <input id="quantity-input-{{ $product->id }}" 
                                    data-id="{{ $product->id }}" 
                                    min="0" 
                                    value="{{ $product->quantity }}" 
                                    type="number" 
                                    name="quantity-{{$product->id}}" 
                                    class="quantity-input px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                    <!--移除、修改按鈕-->
                    <div class="text-center">
                        <form class="m-6" action="{{ route('cart.remove', $product->id) }}" method="POST">
                            @csrf
                            <button type="submit" class="px-4 py-2 mx-5 bg-red-600 text-white rounded-lg hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-black">
                                移除
                            </button>
                        </form>
                        <form class="m-6" action="{{ route('cart.update' , $product->id) }}" method="POST">
                            @csrf
                            <input id="price-hidden-{{ $product->id }}" 
                                    type="hidden" 
                                    name="price-hidden-{{$product->id}}" 
                                    value="{{ $product->price }}">
                            <input id="quantity-hidden-{{ $product->id }}" 
                                    type="hidden" 
                                    name="quantity-hidden-{{$product->id}}" 
                                    value="{{ $product->quantity }}">
                            <button type="submit" class="px-4 py-2 mx-5 bg-green-600 text-white rounded-lg hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-black">
                                修改
                            </button>
                        </form>
                    </div>
                </div>
                @endforeach
            @else
                <p class="text-gray-500 p-4 px-6">詢價車內沒有商品。</p>
            @endif
            
            <!--一次全部更新-->
            <div class="flex justify-center m-6">
                <form class="p-4" action="{{ route('update.all') }}" method="GET" onsubmit="return confirmSubmit()">
                    @csrf
                    @if ($products->isNotEmpty())
                        @foreach ($products as $product)
                            <input type="hidden" name="product_id[]" value="{{ $product->product_id }}">
                            <input id="price-hidden1-{{ $product->id }}" 
                                    type="hidden" 
                                    name="price[]" 
                                    value="{{ $product->price }}">
                            <input id="quantity-hidden1-{{ $product->id }}" 
                                    type="hidden" 
                                    name="quantity[]"
                                    value="{{ $product->quantity }}">
                        @endforeach
                    @endif
                    @if ($products->isNotEmpty())
                    <button type="submit" class="px-4 py-2 mx-5 bg-green-600 text-white rounded-lg hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-black">
                        全部更新
                    </button>
                    @endif
                </form>
            </div>
            
            <!--總數量及價格-->
            <div class="flex justify-center mt-3">
                <h2 class="text-2xl font-bold text-gray-800 mb-6 px-6">商品總數量：
                    @if ($products->isNotEmpty())
                        <span id="allQuantity">
                            {{ $products->sum('quantity') }}  <!-- 計算數量總和 -->
                        </span>
                    @else
                        <span id="allQuantity">0</span>
                    @endif
                </h2>
                <h2 class="text-2xl font-bold text-gray-800 mb-6 px-6 hidden">商品總價：
                    @if ($products->isNotEmpty())
                        <span id="allPrice">
                            {{ $products->sum(fn($product) => $product->price * $product->quantity) }}  <!-- 計算價錢總和 -->
                        </span>
                    @else
                        <span id="allPrice">0</span>
                    @endif
                </h2>
            </div>

            <!--送出詢價-->
            <form action="{{ route('send.order') }}" method="GET" onsubmit="return confirmSubmit()">
                @csrf
                @if ($products->isNotEmpty())
                    @foreach ($products as $product)
                        <input type="hidden" name="brand_category[]" value="{{ $product->brand_category }}">
                        <input type="hidden" name="brand_category_logo[]" value="{{ $product->brand_category_logo }}">
                        <input type="hidden" name="series_category[]" value="{{ $product->series_category }}">
                        <input type="hidden" name="product_categories[]" value="{{ $product->product_categories }}">
                        <input type="hidden" name="system_category[]" value="{{ $product->system_category }}">
                        <input type="hidden" name="product_id[]" value="{{ $product->product_id }}">
                        <input type="hidden" name="product_name[]" value="{{ $product->product_name }}">
                        <input type="hidden" name="price[]" value="{{ $product->price }}">
                        <input type="hidden" name="diameter[]" value="{{ $product->diameter }}">
                        <input type="hidden" name="length[]" value="{{ $product->length }}">
                        <input type="hidden" name="high[]" value="{{ $product->high }}">
                        <input type="hidden" name="cuff[]" value="{{ $product->cuff }}">
                        <input type="hidden" name="angle[]" value="{{ $product->angle }}">
                        <input type="hidden" name="type[]" value="{{ $product->type }}">
                        <input type="hidden" name="post_h[]" value="{{ $product->post_h }}">
                        <input type="hidden" name="image[]" value="{{ $product->image }}">
                        <input type="hidden" name="quantity[]" value="{{ $product->quantity }}">
                    @endforeach
                @endif
                @if ($products->isNotEmpty())
                    <div class="grid grid-cols-1 gap-4 px-4">
                        <div class="flex gap-4 items-center">
                            <p>出貨模式</p>
                            <select name="shipping_mode" class="" required>
                                <option value="出貨模式1">出貨模式1</option>
                                <option value="出貨模式2">出貨模式2</option>
                                <option value="出貨模式3">出貨模式3</option>
                            </select>
                        </div>
                        <input type="text" name="sales_name" value="" placeholder="業務名稱">
                        <input type="text" name="mailing_method" value="" placeholder="郵寄方式" required>
                        <div class="flex gap-4">
                            <p>是否寄出出貨單？</p>
                            <label class="inline-flex items-center gap-3 cursor-pointer">
                                <input type="radio" name="shipping" value="true" required>
                                <span class="text-gray-700">是</span>
                            </label>

                            <label class="inline-flex items-center gap-3 cursor-pointer" required>
                                <input type="radio" name="shipping" value="false">
                                <span class="text-gray-700">否</span>
                            </label>
                        </div>
                        <input type="text" name="mechanism" value="" placeholder="請輸入訂購診所" required>
                        <input type="text" name="mechanism_recipient" value="" placeholder="請輸入收件人" required>
                        <input type="text" name="mechanism_recipient_phone" value="" placeholder="請輸入收件人電話" required>
                        <input type="text" name="mechanism_recipient_address" value="" placeholder="請輸入收件人地址" required>
                        <input type="text" name="technical_name" value="" placeholder="技工所名稱">
                        <input type="text" name="technical_address" value="" placeholder="技工所地址">
                        <input type="text" name="technical_phone" value="" placeholder="技工所電話">
                        <input type="text" name="patient" value="" placeholder="病人名字">
                        <input type="text" name="doctor" value="" placeholder="醫生名字">
                        <textarea name="remark" rows="6" cols="40" placeholder="其他備註"></textarea>
                    </div>
                    <div class="flex justify-center mt-3">
                        <button type="submit" class="text-lg bg-green-600 text-white px-6 py-1 rounded-md hover:bg-green-700">
                            送出詢價
                        </button>
                    </div>
                @endif
            </form>
            
            @if(session('message'))
                <script>
                    alert("{{ session('message') }}");
                </script>
            @endif
        </div>
    </div>
</x-app-layout>

<script>
    //同步更新隱藏price
    document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".price-input").forEach(input => {
        input.addEventListener("input", function () {
            let productId = this.dataset.id; // 取得 data-id
            let hiddenInput = document.querySelector("#price-hidden-" + productId);
            let hiddenInput1 = document.querySelector("#price-hidden1-" + productId);


            if (hiddenInput) {
                hiddenInput.value = this.value; // 同步數值
                hiddenInput1.value = this.value; // 同步數值
                //console.log(`同步更新: #price-hidden-${productId} = ${this.value}`);
                }
            });
        });
    });

    //同步更新隱藏quantity
    document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".quantity-input").forEach(input => {
        input.addEventListener("input", function () {
            let productId = this.dataset.id; // 取得 data-id
            let hiddenInput = document.querySelector("#quantity-hidden-" + productId);
            let hiddenInput1 = document.querySelector("#quantity-hidden1-" + productId);
            
            if (hiddenInput) {
                hiddenInput.value = this.value; // 同步數值
                hiddenInput1.value = this.value; // 同步數值
                //console.log(`同步更新: #quantity-hidden-${productId} = ${this.value}`);
                }
            });
        });
    });

    //再次確認使否更新數量及價錢
    function confirmSubmit() {
        return window.confirm("是否已確認總數量及總價格？");
    }

</script>
